; Bless - Alternate Example.bb
; An example of how to use BLESS with the alternate event notification method turned on.
; (i.e. UseAlternateMethod(True))
;
; Best for Blitz3D, but also usable for BlitzPlus if the default method is not wanted.

Include "bless.bb" ; Required
Graphics 400, 300, 0, 2
Global hwnd = Bless_GetForegroundWindow() ; Should be the Blitz graphics window
AppTitle "BLESS Demo - Press [ESC] to quit"

Bless_DragAcceptFiles(hwnd, True) ; for drag-and-drop (see MSDN)
Bless_UseAlternateMethod(True) ; scancodes instead of character codes

; Let BLESS know which events we're interested in, and associated with which windows
Bless_RegisterEvent(BLESS_0, WM_LBUTTONDOWN, hwnd, hwnd)
Bless_RegisterEvent(BLESS_1, WM_RBUTTONDOWN, hwnd, hwnd)
Bless_RegisterEvent(BLESS_2, WM_DROPFILES, hwnd, hwnd)
Bless_RegisterEvent(BLESS_3, WM_MOUSEWHEEL, hwnd, hwnd)

Print "BLESS (BLitz EventS System) beta"
Print "by Chad Dylan Long"
Print "Copyright 2004 Minty Software, LLC."
Print "www.mintysoftware.com"
Print ""
Print "Things to try:"
Print "  * Drag-and-drop file onto window"
Print "  * Click around with mouse buttons"
Print "  * Use Mousewheel"
Print "  * Press 'n' for the Notepad Demo"
Print ""
Print "For a more comprehensive example, "
Print "  see 'Bless - Default Example.bb'"

While Not KeyHit(1)
	; Using the alternate BLESS method, you must check using KeyHit
	; (i.e. something that checks for scancodes)
	If KeyHit(BLESS_0) Print "Left click"
	If KeyHit(BLESS_1) Print "Right click"
	If KeyHit(BLESS_2)
		Bless_EventData(BLESS_2, Bless_EventData) ; Get eventdata for last processed BLESS_2 event
		fname=CreateBank(256)
		size% = Bless_DragQueryFile3D(Bless_EventData\wparam, 0, fname, BankSize(fname))
		Bless_DragFinish(Bless_EventData\wparam)
		For i = 0 To size-1 : s$ = s$ + Chr$(PeekByte(fname,i)) : Next
		Print s$
		s$=""
		FreeBank(fname)
	EndIf
	If KeyHit(BLESS_3)
		Bless_EventData(BLESS_3, Bless_EventData) ; Get eventdata for last processed BLESS_3 event
		If Bless_EventData\wparam < 0 Then delta$ = "-" Else delta$ = "+"
		Print "Mouse Wheel " + delta
	EndIf
	If KeyHit(BLESS_4) ; Typing in notepad
		Bless_EventData(BLESS_4, Bless_EventData)
		code = Bless_EventData\wparam
		If code >= 33 And code <= 126 Then Print Chr$(code)
	EndIf
	If KeyHit(BLESS_5) ; Notepad terminated
		notepadDemoRunning = False
		Print Int Bless_UnregisterEvent(BLESS_4)
		Print Int Bless_UnregisterEvent(BLESS_5)
		Print "Notepad Demo finished."
	EndIf
	If KeyHit(49) Then ; 'n' - notepad demo
		If Not notepadDemoRunning% Then
			If Int ExecFile("notepad.exe")
				notepadDemoRunning = True
				Delay 100
				NotepadDemo()
			EndIf
		EndIf
	EndIf
Wend

Bless_UnregisterEvent(0) ; Highly recommended before termination -- passing 0 unregisters all BLESS events
End

Function NotepadDemo()
	Print "Notepad Demo:"
	; Get window handles
	notepad = Bless_FindWindowEx(0, 0, "Notepad", "Untitled - Notepad")
	notepadedit = Bless_FindWindowEx(notepad, 0, "Edit", "")
	; Send text to notepad
	notepadstring$ = "Start typing here, then look at the BLESS window..."+Chr$(10)
	notepadstring=notepadstring+"Close Notepad to be able to run the Notepad Demo again."+Chr$(10)
	notepadstring=notepadstring+"----------------------------"+Chr$(10)
	For i = 1 To Len(notepadstring)
		Bless_SendMessage(notepadedit, $102, Asc(Mid$(notepadstring, i, 1)), 0)
		;Delay 30
	Next
	Bless_SendMessage(notepadedit, $102, 10, 0)
	; Register BLESS events
	Bless_RegisterEvent(BLESS_4, WM_CHAR, notepadedit, hwnd)
	Bless_RegisterEvent(BLESS_5, WM_DESTROY, notepad, hwnd)
End Function
